<?php

namespace App\Http\Controllers\Site\Fee;

use App\Http\Controllers\ProjectController;
use App\Jobs\DemandSlipJob;
use App\Models\Academic\AcademicAdmissionFeeType;
use App\Models\Academic\AcademicFeeHead;
use App\Models\Academic\AcademicGeneralFeeType;
use App\Models\Academic\AcademicMonthName;
use App\Models\Examinations\Examination;
use App\Models\Site\Fee\Fine\SiteStudentFeeFine;
use App\Models\Site\Fee\GlobalSiteStudentFeeGenerate;
use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\SiteStudentFeeFineAllocation;
use App\Models\Site\Fee\SiteStudentFeeGenerate;
use App\Models\Site\Fee\SiteStudentFeePaymentHistory;
use App\Models\Site\Fee\SiteStudentFeeSubHeadAllocation;
use App\Models\Site\Fee\SiteStudentFeeWaiverOfferHistory;
use App\Models\Site\GlobalSiteInfo;
use App\Models\Site\Notice\Notice;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Student\StudentHistory;
use App\Models\User\User;
use App\Notifications\Site\NoticeNotification;
use App\User as MainUser;
use App\Notifications\Site\StudentPaymentNotification;
use Carbon\CarbonPeriod;
use DB;
use Exception;
use Illuminate\Http\JsonResponse;
use JsonSchema\Exception\ValidationException;
use Illuminate\Support\Facades\Notification;
use NumberFormatter;
use Carbon\Carbon;
use Auth;
use Response;
use PDF;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Site\Fee\SiteStudentHeadWiseFeePaymentHistory;
use Session;
use Error;
use Illuminate\Support\Facades\Auth as FacadesAuth;

class SiteStudentFeeDemandSlipController extends ProjectController
{
    private $siteStudentFeeGenerate;
    private $siteStudentFeeDemandSlipDetails;
    private $siteStudentFeeWaiverOfferHistory;

    public function __construct(SiteStudentFeeGenerate $siteStudentFeeGenerate, SiteStudentFeeDemandSlipDetails $siteStudentFeeDemandSlipDetails,
                                SiteStudentFeeWaiverOfferHistory $siteStudentFeeWaiverOfferHistory)
    {
        $this->middleware('auth');
        //$this->middleware('eduworlduserchecker');
       // $this->middleware('sitepagechecker');
        $this->siteStudentFeeGenerate = $siteStudentFeeGenerate;
        $this->siteStudentFeeDemandSlipDetails = $siteStudentFeeDemandSlipDetails;
        $this->siteStudentFeeWaiverOfferHistory = $siteStudentFeeWaiverOfferHistory;

    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

/*
        $demandSlipDetails = $this->siteStudentFeeDemandSlipDetails
            ->whereIn('student_history_id', [71,72])
            ->where('status', 1)
            ->get();
        dd($demandSlipDetails[0]->student_history_id);

        dispatch(new DemandSlipJob($demandSlipDetails));*/





        //$fbb = SiteStudentFeeGenerate::where('id', 394)->update(['demand_slip_create_status' => 1]);


/*
        $users = MainUser::whereIn('id', [85])->select(['id'])->get();

        $the_notice=Notice::find(9);

        Notification::send($users, new NoticeNotification($the_notice));





        $users = MainUser::whereIn('id', [85])->select(['id'])->get();

       // dd($users);

        Notification::send($users, new StudentPaymentNotification());*/

     //   dd('hjhj');
    }

    public function getDemadSlipPdf($slipNo = null)
    {

        $demand_slip_details = SiteStudentFeeDemandSlipDetails::where('slip_no', $slipNo)->first();
        $student_details = StudentHistory::with(['student', 'stClass', 'accGroup', 'section'])->where('id', $demand_slip_details->student_history_id)->first();
        $slip_no = $slipNo;
        $user_details = User::where('id', $demand_slip_details->created_by)->where('site_id', Session::get('SITE_ID'))->first();
        $user_name = $user_details->first_name;

        $fee_generate_id_splite = explode(',', $demand_slip_details->site_student_fee_generate_ids);
        $fee_generate_list = SiteStudentFeeGenerate::whereIn('id', $fee_generate_id_splite)->get();
        $fee_allocation_details = [];

        foreach ($fee_generate_list as $key => $value) {

            $fee_allocation_details[$key] = SiteStudentFeeFineAllocation::with(['academicFeeHead', 'academicFeeGroup', 'academicFeeSubHead'])->where('id', $value->site_student_fee_fine_allocation_id)->first();
            foreach ($fee_allocation_details as $k => $v) {

                if ($v->academicFeeHead->name == 'Admission') {
                    $fee_type = AcademicAdmissionFeeType::where('id', $value->fee_head_type_id)->first();
                    $fee_allocation_details[$key]['fee_type_name'] = $fee_type->name;

                } elseif ($v->academicFeeHead->name == 'Monthly') {
                    $fee_type = AcademicMonthName::where('id', $value->fee_head_type_id)->first();
                    $fee_allocation_details[$key]['fee_type_name'] = $fee_type->name;

                } elseif ($v->academicFeeHead->name == 'Examination') {
                    $fee_type = Examination::where('id', $value->fee_head_type_id)->first();
                    $fee_allocation_details[$key]['fee_type_name'] = $fee_type->examination_name;
                }
            }

        }

         $previous_due=0;
        if($demand_slip_details->previous_site_student_fee_demand_slip_detail_id){
            $previous_due=$demand_slip_details->previous_due;
        }

        $total = $this->convertNumberToWord($demand_slip_details->total_amount);
        $total_with_due = $demand_slip_details->fee_amount + $previous_due;

        $pdf = PDF::loadView('default.admin.site.student-fee.report.demand-slip-pdf',
            compact('demand_slip_details', 'student_details', 'slip_no', 'fee_allocation_details', 'total_with_due', 'user_name', 'total'));
        return $pdf->stream(time() . '-demand-slip.pdf', 'fee_allocation_details');
    }


    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getClassDeptBaseSiteFeeHeadSubHeadList(Request $request)
    {
        $siteStudentIDs = $this->returnSiteStudentIDs($request);
        $stdNumbers = $siteStudentIDs->count();
        $siteFeeHeadIDs = SiteStudentFeeSubHeadAllocation::distinct('academic_fee_head_id')
            ->pluck('academic_fee_head_id');

        $siteFeeHeadList = AcademicFeeHead::whereIn('id', $siteFeeHeadIDs)->get();

        if ($request->student_history_id) {
            $stdIDs = [$request->student_history_id];
        } else {
            $forTest = $this->returnSiteStudentIDs($request);
            $stdIDs = $forTest->pluck('id');
        }

        //=================site demand slip create list=============================
        $siteDemandSlipCreateList = SiteStudentFeeGenerate::whereIn('student_history_id', $stdIDs)
            ->distinct('academic_fee_head_id', 'fee_head_type_id')
            ->where('demand_slip_create_status', true)
            ->get(['academic_fee_head_id', 'fee_head_type_id']);

        $siteDemandSlipCreateCheckArray = [];
        $siteDemandSlipCreateCheckArr = Array();

        foreach ($siteDemandSlipCreateList as $key => $value) {

            $siteDemandSlipCreateListCount = SiteStudentFeeGenerate::whereIn('student_history_id', $stdIDs)
                ->where('academic_fee_head_id', $value->academic_fee_head_id)
                ->where('fee_head_type_id', $value->fee_head_type_id)
                ->distinct('student_history_id')
                ->where('demand_slip_create_status', true)
                ->get(['student_history_id'])
                ->count();

            if (($siteDemandSlipCreateListCount * 100 / count($stdIDs)) >= 90) {
                $siteDemandSlipCreateCheckArr['academic_fee_head_id'] = $value->academic_fee_head_id;
                $siteDemandSlipCreateCheckArr['fee_head_type_id'] = $value->fee_head_type_id;
                $siteDemandSlipCreateCheckArray[$key] = array_merge($siteDemandSlipCreateCheckArr);
            }
        }

        $siteDemandSlipCreateCheck = collect($siteDemandSlipCreateCheckArray);

        //=================site fee generate create list=============================
        $siteFeeGenerateListCreate = SiteStudentFeeGenerate::whereIn('student_history_id', $stdIDs)->where('status', 1)
            ->distinct('academic_fee_head_id', 'fee_head_type_id')
            ->get(['academic_fee_head_id', 'fee_head_type_id']);


        $siteFeeGenerateCheckArray = [];
        $siteFeeGenerateCheckArr = Array();

        foreach ($siteFeeGenerateListCreate as $key => $value) {

            $siteFeeGenerateCreateList = SiteStudentFeeGenerate::whereIn('student_history_id', $stdIDs)
                ->where('academic_fee_head_id', $value->academic_fee_head_id)
                ->where('fee_head_type_id', $value->fee_head_type_id)
                ->distinct('student_history_id')
                ->get(['student_history_id'])
                ->count();

            if (($siteFeeGenerateCreateList * 100 / count($stdIDs)) == 100) {
                $siteFeeGenerateCheckArr['academic_fee_head_id'] = $value->academic_fee_head_id;
                $siteFeeGenerateCheckArr['fee_head_type_id'] = $value->fee_head_type_id;

                $siteFeeGenerateCheckArray[$key] = array_merge($siteFeeGenerateCheckArr);
            }

        }
        $siteFeeGenerateCheck = collect($siteFeeGenerateCheckArray);

        //====================================================================
        $sitePaymentListCreate = SiteStudentFeeGenerate::whereIn('student_history_id', $stdIDs)
            ->with(['siteStudentFeeDemandSlipDetails' => function ($query) {
                $query->where('status', false);
                $query->select('id');
            }])
            ->where('demand_slip_create_status', true)
            ->distinct('academic_fee_head_id', 'fee_head_type_id', 'site_student_fee_demand_slip_detail_id')
            ->get(['academic_fee_head_id', 'fee_head_type_id', 'site_student_fee_demand_slip_detail_id']);
         //   dd($sitePaymentListCreate);
        $countPaidDemandSlip = $sitePaymentListCreate->where('siteStudentFeeDemandSlipDetails', '!=', null);
        $sitePaymentCheckArray = [];
        $sitePaymentCheckArr = Array();

        foreach ($siteFeeGenerateListCreate as $key => $value) {

            $sitePaymentCreateList = $countPaidDemandSlip
                ->where('academic_fee_head_id', $value->academic_fee_head_id)
                ->where('fee_head_type_id', $value->fee_head_type_id)
                ->count();

            if (($sitePaymentCreateList * 100 / count($stdIDs)) >= 20) {
                $sitePaymentCheckArr['academic_fee_head_id'] = $value->academic_fee_head_id;
                $sitePaymentCheckArr['fee_head_type_id'] = $value->fee_head_type_id;

                $sitePaymentCheckArray[$key] = array_merge($sitePaymentCheckArr);
            }
        }

        $sitePaymentCheck = collect($sitePaymentCheckArray);

        $headBaseTypelistArray = [];
        $headBaseTypelistArr = Array();
        foreach ($siteFeeHeadList as $key => $value) {

            if ($value->head_key == 'monthly') {
                $list = AcademicMonthName::get();
                $headBaseTypelistArr['head_type'] =
                    $this->headTypeList($list, $value->id, $siteDemandSlipCreateCheck, $siteFeeGenerateCheck, $sitePaymentCheck);
//                return $siteFeeGenerateCheck;

            } else if ($value->head_key == 'examination') {

                $selectedSiteGroupList = SiteInfoSetting::first();
                $list = Examination::whereIn('id', explode(',', $selectedSiteGroupList->examination_ids))->get();

                $headBaseTypelistArr['head_type'] =
                    $this->headTypeList($list, $value->id, $siteDemandSlipCreateCheck, $siteFeeGenerateCheck, $sitePaymentCheck);

            } else if ($value->head_key == 'admission') {

                $list = AcademicAdmissionFeeType::get();
                $headBaseTypelistArr['head_type'] =
                    $this->headTypeList($list, $value->id, $siteDemandSlipCreateCheck, $siteFeeGenerateCheck, $sitePaymentCheck);
//                return $headBaseTypelistArr;

            } else if ($value->head_key == 'general') {

                $list = AcademicGeneralFeeType::get();
                $headBaseTypelistArr['head_type'] =
                    $this->headTypeList($list, $value->id, $siteDemandSlipCreateCheck, $siteFeeGenerateCheck, $sitePaymentCheck);

            }
            $headBaseTypelistArr['select_fee_head_id'] = false;
            $headBaseTypelistArray[$key] = array_merge($headBaseTypelistArr, $value->toArray());
        }
      //  dd($headBaseTypelistArray);
        return response()->json([$headBaseTypelistArray, $siteStudentIDs, $stdNumbers], 200, []);

    }


    private function returnSiteStudentIDs(Request $request)
    {

        $data = $request->all();

        if ($request->academic_class_id) {

            if ($request->academic_class_group_present) {

                $siteStudentIDs = StudentHistory::with(['student' => function ($query) {
                    $query->select(['id','username']);
                }])
                    ->where('academic_version_id', $request->academic_version_id)
                    ->where('academic_shift_id', $request->academic_shift_id)
                    ->where('academic_year_id', $request->academic_year_id)
                    ->where('academic_class_id', $request->academic_class_id)
                    ->where('status', true)
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                        return $query->where('academic_section_id', $data['academic_section_id']);
                    })
                    ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })
                    ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                        return $query->where('academic_session_id', $data['academic_session_id']);
                    })
                    ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                        return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                    })
                    ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                    })
                    ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->orderBy('student_roll_number')
                    ->orderBy('academic_section_id')
                    ->orderBy('academic_class_group_id')
                    ->orderBy('academic_class_id')
                    ->orderBy('academic_department_id')
                    ->get(['id', 'user_id','student_roll_number']);


            } else {

                $siteStudentIDs = StudentHistory::with(['student' => function ($query) {
                    $query->select(['id','username']);
                }])
                    ->where('academic_version_id', $request->academic_version_id)
                    ->where('academic_shift_id', $request->academic_shift_id)
                    ->where('academic_year_id', $request->academic_year_id)
                    ->where('academic_class_id', $request->academic_class_id)
                    ->where('status', true)
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                        return $query->where('academic_section_id', $data['academic_section_id']);
                    })
                    ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                        return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                    })
                    ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                    })
                    ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->orderBy('student_roll_number')
                    ->orderBy('academic_section_id')
                    ->orderBy('academic_class_group_id')
                    ->orderBy('academic_class_id')
                    ->orderBy('academic_department_id')
                    ->get(['id', 'user_id','student_roll_number']);


            }

        }

        return $siteStudentIDs;

    }

    private function headTypeList($list, $head_id, $siteDemandSlipCreateCheck, $siteFeeGenerateCheck, $sitePaymentCheck)
    {

        $headBaseTypelist = [];
        $headBaseTypelistArr = Array();
        $keyss=0;
        foreach ($list as $keys => $values) {

            $check = $siteDemandSlipCreateCheck->where('academic_fee_head_id', $head_id)
                ->where('fee_head_type_id', $values->id)->first();

            $checkFeeGenerate = $siteFeeGenerateCheck->where('academic_fee_head_id', $head_id)
                ->where('fee_head_type_id', $values->id)->first();
//            return  $checkFeeGenerate;
            $checkPayment = $sitePaymentCheck->where('academic_fee_head_id', $head_id)
                ->where('fee_head_type_id', $values->id)->first();


            if ($checkFeeGenerate) {
//                return [$check, $checkFeeGenerate, $checkPayment];
//                \Log::info([$check,$checkFeeGenerate,$checkPayment]);
//                Log::info('ok');

                if ($checkPayment) {
                    $headBaseTypelistArr['demand_slip_created'] = 2;
                } else {
                    if ($check) {
                        $headBaseTypelistArr['demand_slip_created'] = 1;
                    } else {
                        $headBaseTypelistArr['demand_slip_created'] = 0;
                    }
                }

                $headBaseTypelistArr['id'] = $values->id;
                $headBaseTypelistArr['name'] = $values->examination_name ? $values->examination_name : $values->name;
                $headBaseTypelistArr['select_head_type_id'] = false;

                $headBaseTypelist[$keyss] = array_merge($headBaseTypelistArr);
                $keyss++;
            }

        }

        return $headBaseTypelist;
    }

//    ==========================create and update==============================

    public function createSiteBaseDemandSlip(Request $request)
    {
//        return $request->generated_date;

//         throw new Error('sorry');
//        return $request->student_history_id['id'];
        DB::beginTransaction();
        try {
            $studentFeebaseArrayCollect = $this->returnStudentFeebaseArrayForCreate($request);
           // dd($studentFeebaseArrayCollect);

            if ($request->student_history_id) {
                $std_id[] = $request->student_history_id['id'];
                $SiteStudentIDArray = $std_id;
            } else {
                $SiteStudentIDs = $this->returnSelectedSiteStudentIDs($request);
                $SiteStudentIDArray = $SiteStudentIDs->pluck('id');
            }

            $StudentLastDemandSlip = SiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $SiteStudentIDArray)
                ->where('status', true)
                ->get();

            $today = Carbon::today();

            $charges = [];
            $site_student_fee_generate_ids = [];
            $site_student_fee_waiver_ids = [];
            $unpaidSlipID = [];
            foreach ($studentFeebaseArrayCollect as $key => $value) {



                $site_student_fee_generate_ids[] = $value['site_student_fee_generate_ids'];
                $site_student_fee_waiver_ids[] = $value['site_student_fee_waiver_offer_history_ids'];

                $checkUnpaidDemandSlip = $StudentLastDemandSlip->where('student_history_id', $value['id'])->where('status', 1)->first();
                $checkUnpaidpayment = SiteStudentFeePaymentHistory::where('student_history_id', $value['id'])
                    ->where('due_amount', '>', 0)
                    ->where('status', 1)
                    ->orderBy('id', 'desc')
                    ->first();

                $lastDemandSlipId = null;
                $previousClassDuePaymentHistoryId = null;

                if ($checkUnpaidDemandSlip) {
                    $lastDemandSlipId = $checkUnpaidDemandSlip->id;
                    $unpaidSlipID[] = $lastDemandSlipId;
                    if ($checkUnpaidpayment) {
                        $previous_due = $checkUnpaidpayment->due_amount;
                    } else {
                        $previous_due = $checkUnpaidDemandSlip->total_amount;
                    }

                    $checkUnpaidDemandSlip->update([
                        'status' => 0,
                    ]);

                    //==============due fine===================================
//                    $due_fine = 0;
//                    if($checkUnpaidDemandSlip->due_fine){
//                        $due_fine = $checkUnpaidDemandSlip->due_fine;
//                    }
//
//                    if($due_fine>0){
//                        $fee_fine_create = SiteStudentFeeFine::create([
//                            'site_student_fee_demand_slip_details_id' => $checkUnpaidDemandSlip->id,
//                            'student_history_id' => $value['id'],
//                            'fine_amount' => $due_fine,
//                            'fee_type' => 'duefine',
//                        ]);
//                    }
//

                    $mytime = Carbon::now();
                    $today_date =  $mytime->toDateString();


                    if($checkUnpaidDemandSlip->payment_from_date){
                        $start_date = $checkUnpaidDemandSlip->payment_from_date;
                        $end_date = $checkUnpaidDemandSlip->payment_to_date;

                        $period = CarbonPeriod::create($start_date, $end_date);

                        $due_fine_test = 1;
                        $due_fine = 0;

                        foreach ($period as $date) {
                            $formated_date =  $date->format('Y-m-d');
                            if($formated_date == $today_date){
                                $due_fine_test = 0;
                            }
                        }

                        if($due_fine_test==1){
                            $due_fine = $checkUnpaidDemandSlip->due_fine;
                        }else{
                            $due_fine = 0;
                        }

                        if($due_fine>0){
                            $fee_fine_create = SiteStudentFeeFine::create([
                                'site_student_fee_demand_slip_details_id' => $checkUnpaidDemandSlip->id,
                                'student_history_id' => $value['id'],
                                'fine_amount' => $due_fine,
                                'fee_type' => 'duefine',
                            ]);
                        }
                    }
                    //==============end due fine================================
//                    if($checkUnpaidDemandSlip->payment_fine_status== true){
//                        $due_fine = $checkUnpaidDemandSlip->due_fine;
//                    }


                } else {
                    $due_fine = 0;
                    $lastDemandSlip = SiteStudentFeeDemandSlipDetails::where('student_history_id', $value['id'])->where('status', 0)->orderBy('id', 'desc')->first();
                    if($lastDemandSlip){
                        $lastDemandSlipId = $lastDemandSlip->id;
                    }else{
                        $lastDemandSlipId = null;
                    }

                    if ($checkUnpaidpayment) {
                        $previous_due = $checkUnpaidpayment->due_amount;
                    } else {

                        $checkUnpaidPaymentOfPreviousClassFromPaymentHistory = SiteStudentFeePaymentHistory::where('due_transfer_to_promoted_student_history_id', $value['id'])
                            ->where('previous_academic_class_due_status', 1)
                            ->first();
                        if($checkUnpaidPaymentOfPreviousClassFromPaymentHistory){
                            $previous_due = $checkUnpaidPaymentOfPreviousClassFromPaymentHistory->due_amount;
                            $previousClassDuePaymentHistoryId = $checkUnpaidPaymentOfPreviousClassFromPaymentHistory->id;
                            $checkUnpaidPaymentOfPreviousClassFromPaymentHistory->update([
                                'previous_academic_class_due_status' => 0,
                                'status' => 0,
                            ]);

                        }else{
                            $checkUnpaidPaymentOfPreviousClassFromDemandSlipDetails = SiteStudentFeeDemandSlipDetails::where('due_transfer_to_promoted_student_history_id', $value['id'])
                                ->where('previous_academic_class_due_status', 1)
                                ->first();
                            if($checkUnpaidPaymentOfPreviousClassFromDemandSlipDetails){
                                $previous_due = $checkUnpaidPaymentOfPreviousClassFromDemandSlipDetails->total_amount;

                                $mytime = Carbon::now();
                                $today_date =  $mytime->toDateString();

                                if($checkUnpaidPaymentOfPreviousClassFromDemandSlipDetails->payment_from_date) {
                                    $start_date = $checkUnpaidPaymentOfPreviousClassFromDemandSlipDetails->payment_from_date;
                                    $end_date = $checkUnpaidPaymentOfPreviousClassFromDemandSlipDetails->payment_to_date;

                                    $period = CarbonPeriod::create($start_date, $end_date);

                                    $due_fine_test = 1;

                                    foreach ($period as $date) {
                                        $formated_date =  $date->format('Y-m-d');
                                        if($formated_date == $today_date){
                                            $due_fine_test = 0;
                                        }
                                    }

                                    if($due_fine_test==1){
                                        $due_fine = $checkUnpaidPaymentOfPreviousClassFromDemandSlipDetails->due_fine;
                                    }else{
                                        $due_fine = 0;
                                    }

                                    if($due_fine>0){
                                        $fee_fine_create = SiteStudentFeeFine::create([
                                            'site_student_fee_demand_slip_details_id' => $checkUnpaidDemandSlip->id,
                                            'student_history_id' => $value['id'],
                                            'fine_amount' => $due_fine,
                                            'fee_type' => 'duefine',
                                            'created_date' => $request->generated_date,
                                        ]);
                                    }

                                }

                                $lastDemandSlipId = $checkUnpaidPaymentOfPreviousClassFromDemandSlipDetails->id;
                                $checkUnpaidPaymentOfPreviousClassFromDemandSlipDetails->update([
                                    'previous_academic_class_due_status' => 0,
                                    'status' => 0,
                                ]);

                            }else{
                                $previous_due = 0;
                            }

                        }

                    }

                }

                $checkActivePayment = SiteStudentFeePaymentHistory::where('student_history_id', $value['id'])->where('status', 1)->get();
                if(count($checkActivePayment)){
                    foreach ($checkActivePayment as $keyy => $vall){
                        $vall->update([
                            'status'=> 0,
                        ]);
                    }
                }

                if ($value['fee_amount'] > 0 || $previous_due > 0) {
                    $charges[] = [
                        'student_history_id' => $value['id'],
                        'site_student_fee_generate_ids' => $value['site_student_fee_generate_ids'],
                        'site_student_fee_waiver_offer_history_ids' => $value['site_student_fee_waiver_offer_history_ids'],
                        'fee_amount' => $value['fee_amount'],
                        'waiver_amount' => $value['waiver_amount'],
                        'total_amount' => $value['total_amount'] + $previous_due,
                       // 'previous_due' => $previous_due,
                        'previous_due' => '',
                        'special_waiver_amount' => $value['special_waiver_amount'],

                        'payment_fine_status' => $request->show_fine_div,
                        'payment_from_date' => $request->active_date['start']??null,
                        'payment_to_date' => $request->active_date['end']??null,
                        'delay_fine' => $request->delay_fine??0,
                        'due_fine' => $request->due_fine??0,

                        'academic_group_id' => Session::get('ACADEMIC_GROUP_ID'),
                        'created_by' => Auth::user()->id,
                        'status' => true,
                        'site_id' => $value['site_id'],
                        'previous_site_student_fee_demand_slip_detail_id' => $lastDemandSlipId,
                        'previous_class_due_payment_history_id' => $previousClassDuePaymentHistoryId,
                        'created_at' => $today,
                        'created_date' => $request->generated_date,

//                'payment_duration' => ,
//                'offer_amount' => ,
                    ];



                    if($request->sendSms){
                        $student_history = StudentHistory::where('id', $value['id'])->with('student')->first();
                        $phone_number =  $student_history->student->contact_number;
                        $student_name = $student_history->student->full_name;
                        $payable_amount = $value['total_amount'] + $previous_due;
                        $the_site = SiteInfo::findOrFail(Session::get('SITE_ID'));

//                        $url = config('app.url');

                        $sms_txt = "Demand Slip Generated";
                        $sms_txt .='nl'.$student_name;
                        $sms_txt .= 'nl'.'Payable Amount'.$payable_amount;
                        $sms_txt .= 'nl' . 'Regards:' . $the_site->site_name;

                        $tt = $this->sendSms($the_site->id, $phone_number, $sms_txt );
                    }

                }

            }

            $site_student_fee_generate_ids_string = implode(',', $site_student_fee_generate_ids);
            $site_student_fee_generate_id = array_filter(explode(',', $site_student_fee_generate_ids_string));

            $site_student_fee_waiver_ids_string = implode(',', $site_student_fee_waiver_ids);
            $site_student_fee_waiver_id = explode(',', $site_student_fee_waiver_ids_string);

            if (count($charges) > 0) {
                SiteStudentFeeDemandSlipDetails::insert($charges);
            }

            $studentHistoryIDs = $studentFeebaseArrayCollect->pluck('id');
            $RecentelyCreatedDemandSlip = SiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $studentHistoryIDs)
                ->where('status', true)
                ->get(['id', 'student_history_id', 'site_student_fee_generate_ids', 'site_student_fee_waiver_offer_history_ids']);

            foreach ($studentFeebaseArrayCollect as $key => $value) {
                $checkID = $RecentelyCreatedDemandSlip->where('student_history_id', $value['id'])
                    ->where('site_student_fee_generate_ids', $value['site_student_fee_generate_ids'])->first();
                if($checkID){
                    SiteStudentFeeGenerate::whereIn('id', explode(',', $value['site_student_fee_generate_ids']))
                       // ->where('demand_slip_create_status','=',false)
                        ->update(['site_student_fee_demand_slip_detail_id' => $checkID->id]);
                }
            }

            foreach ($studentFeebaseArrayCollect as $key => $value) {

                $checkID = $RecentelyCreatedDemandSlip->where('student_history_id', $value['id'])
                    ->where('site_student_fee_generate_ids', $value['site_student_fee_generate_ids'])->first();
                if($checkID){
                    SiteStudentFeeWaiverOfferHistory::whereIn('id', explode(',', $value['site_student_fee_waiver_offer_history_ids']))
                        ->where('site_student_fee_demand_slip_detail_id','=',null)
                        ->update(['site_student_fee_demand_slip_detail_id' => $checkID->id]);
                }
            }

            SiteStudentFeeGenerate::whereIn('id', $site_student_fee_generate_id)
                ->update(['demand_slip_create_status' => true]);

            SiteStudentFeeWaiverOfferHistory::whereIn('id', $site_student_fee_waiver_id)
                ->update(['demand_slip_create_status' => true]);

            SiteStudentFeeDemandSlipDetails::whereIn('id', $unpaidSlipID)
                ->update(['status' => false]);

                   ///
               //   dd($site_student_fee_generate_ids);
                foreach($site_student_fee_generate_id as $key =>$fee_generate_id){
                    $student_fee=SiteStudentFeeGenerate::where('id',$fee_generate_id)
                    ->where('demand_slip_create_status',true)
                    ->first();
                   // ->whereIn('site_student_fee_demand_slip_detail_id');
              if($student_fee){


                $student_fee_waiver_offer=SiteStudentFeeWaiverOfferHistory::where('student_history_id',$student_fee->student_history_id)
                        ->where('site_student_fee_fine_allocation_id',$student_fee->site_student_fee_fine_allocation_id)
                        ->where('academic_fee_sub_head_id',$student_fee->academic_fee_sub_head_id)
                        ->where('demand_slip_create_status',true)
                        ->first();

                if($student_fee_waiver_offer){

                    $headWiseFeePaymentHistory=new SiteStudentHeadWiseFeePaymentHistory();
                    $headWiseFeePaymentHistory->student_fee_generate_id=$student_fee->id;
                    $headWiseFeePaymentHistory->student_history_id=$student_fee->student_history_id;

                    $headWiseFeePaymentHistory->amount=$student_fee->amount;

                    if($student_fee_waiver_offer->percantage_status){
                        $waiver_amount=($student_fee->amount*$student_fee_waiver_offer->amount)/100;
                        $payable_amount=$student_fee->amount-$waiver_amount;
                    }else{
                        $waiver_amount=$student_fee_waiver_offer->amount;
                        $payable_amount=$student_fee->amount-$waiver_amount;
                    }

                    $headWiseFeePaymentHistory->payable_amount=$payable_amount;
                    $headWiseFeePaymentHistory->waiver_amount=$waiver_amount;
                    $headWiseFeePaymentHistory->sub_total_waiver_amount=$waiver_amount;

                    $headWiseFeePaymentHistory->payment_due_status=false;

                    $headWiseFeePaymentHistory->status=true;
                    $headWiseFeePaymentHistory->collected_by=Auth::user()->id;

                    $headWiseFeePaymentHistory->save();
                }
                }
                }




            DB::commit();

            //======================notification========================

            $demandSlipDetails = $this->siteStudentFeeDemandSlipDetails->whereIn('student_history_id', $SiteStudentIDArray)
                                ->where('status', 1)->get();

            dispatch(new DemandSlipJob($demandSlipDetails));

            //======================end========================

            return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);

        }
        catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }

    }


//    ========================================================

private function returnStudentFeebaseArrayForCreate(Request $request)
{

    $SiteStudentIDs = $this->returnSelectedSiteStudentIDs($request);

//        return $SiteStudentIDs;
    if ($request->student_history_id) {
        $std_id[] = $request->student_history_id['id'];
        $SiteStudentIDArray = $std_id;
//            $SiteStudentIDArray=[$request->student_history_id];
    } else {

        $SiteStudentIDArray = $SiteStudentIDs->pluck('id');
    }


    //=======================Fee Generate and Waiver Generate combination

    $section_id = $request->academic_section_id;
    $studentBaseGeneratedFee = SiteStudentFeeGenerate::with(['siteStudentFeeFineAllocation' => function ($query) {
        $query->select('id', 'academic_fee_head_id');
        $query->with(['academicFeeHead']);
    }])
        ->whereIn('student_history_id', $SiteStudentIDArray)
        ->where('status', true)
        ->get();
   //     dd($studentBaseGeneratedFee);

//        \Log::info($studentBaseGeneratedFee);


    $studentBaseGeneratedFeeWaiver = SiteStudentFeeWaiverOfferHistory::with(['siteStudentFeeFineAllocation' => function ($query) {
        $query->select('id', 'academic_fee_head_id');
        $query->with(['academicFeeHead']);
    }])
        ->whereIn('student_history_id', $SiteStudentIDArray)
        ->where('status', true)
        ->get();



    $studentBaseGeneratedFeeWaiverArr = Array();
    $studentBaseGeneratedFeeWaiverArray = [];
    foreach ($studentBaseGeneratedFeeWaiver as $key => $value) {

        $studentBaseGeneratedFeeWaiverArr['id'] = $value->id;
        $studentBaseGeneratedFeeWaiverArr['student_history_id'] = $value->student_history_id;
        $studentBaseGeneratedFeeWaiverArr['amount'] = $value->amount;
        $studentBaseGeneratedFeeWaiverArr['fee_head_type_id'] = $value->fee_head_type_id;
        $studentBaseGeneratedFeeWaiverArr['site_student_fee_fine_allocation_id'] = $value->site_student_fee_fine_allocation_id;
        $studentBaseGeneratedFeeWaiverArr['academic_fee_head_id'] = $value->siteStudentFeeFineAllocation ? $value->siteStudentFeeFineAllocation->academic_fee_head_id : null;
        $studentBaseGeneratedFeeWaiverArr['head_key'] = $value->siteStudentFeeFineAllocation ? $value->siteStudentFeeFineAllocation->academicFeeHead->head_key : null;
        $studentBaseGeneratedFeeWaiverArr['percantage_status'] = $value->percantage_status;

        $studentBaseGeneratedFeeWaiverArray[$key] = array_merge($studentBaseGeneratedFeeWaiverArr);
    }

    $studentBaseGeneratedFeeWaiverFinalArray = collect($studentBaseGeneratedFeeWaiverArray);

    $studentBaseGeneratedFeeArr = Array();
    $studentBaseGeneratedFeeArray = [];
    foreach ($studentBaseGeneratedFee as $key => $value) {

        $checkWaiver = $studentBaseGeneratedFeeWaiverFinalArray->where('student_history_id', $value['student_history_id'])
            ->where('site_student_fee_fine_allocation_id', $value['site_student_fee_fine_allocation_id'])
            ->where('fee_head_type_id', $value['fee_head_type_id'])
            ->first();


        if ($checkWaiver) {
            $studentBaseGeneratedFeeArr['fee_generate_id'] = $value->id;
            $studentBaseGeneratedFeeArr['student_history_id'] = $value->student_history_id;
            $studentBaseGeneratedFeeArr['fee_amount'] = $value->amount;
            $studentBaseGeneratedFeeArr['fee_head_type_id'] = $value->fee_head_type_id;
            $studentBaseGeneratedFeeArr['academic_fee_head_id'] = $value->siteStudentFeeFineAllocation->academic_fee_head_id;
            $studentBaseGeneratedFeeArr['head_key'] = $value->siteStudentFeeFineAllocation->academicFeeHead->head_key;


            $studentBaseGeneratedFeeArr['waiver_generate_id'] = $checkWaiver['id'];
            $studentBaseGeneratedFeeArr['waiver_amount'] = $checkWaiver['percantage_status'] ? (($checkWaiver['amount']) * $value->amount / 100) : $checkWaiver['amount'];
            $studentBaseGeneratedFeeArr['waiver_percantage'] = $checkWaiver['percantage_status'] ? $checkWaiver['amount'] : 0;
            $studentBaseGeneratedFeeArr['percantage_status'] = $checkWaiver['percantage_status'];

        } else {
//                \Log::info($value);
            $studentBaseGeneratedFeeArr['fee_generate_id'] = $value->id;
            $studentBaseGeneratedFeeArr['student_history_id'] = $value->student_history_id;
            $studentBaseGeneratedFeeArr['fee_amount'] = $value->amount;
            $studentBaseGeneratedFeeArr['fee_head_type_id'] = $value->fee_head_type_id;
            $studentBaseGeneratedFeeArr['academic_fee_head_id'] = $value->siteStudentFeeFineAllocation->academic_fee_head_id;
            $studentBaseGeneratedFeeArr['head_key'] = $value->siteStudentFeeFineAllocation->academicFeeHead->head_key;

            $studentBaseGeneratedFeeArr['waiver_generate_id'] = null;
            $studentBaseGeneratedFeeArr['waiver_amount'] = 0;
            $studentBaseGeneratedFeeArr['waiver_percantage'] = 0;
            $studentBaseGeneratedFeeArr['percantage_status'] = 0;

        }

        $studentBaseGeneratedFeeArray[$key] = array_merge($studentBaseGeneratedFeeArr);

    }

    $studentBaseGeneratedFeeFinalArray = collect($studentBaseGeneratedFeeArray);



    $studentFeebaseArr = Array();
    $studentFeebaseArray = [];
    foreach ($SiteStudentIDs as $key => $value) {

        $studentFeeAmount = [];
        $studentFeeGenerate = [];

        $studentWaiverAmount = [];
        $studentWaiverGenerate = [];
      //  dd($request->FeeHeadTypeList);
        foreach ($request->FeeHeadTypeList as $keys => $values) {

            if ($values['select_fee_head_id']) {


                foreach ($values['head_type'] as $keyst => $valuest) {

                    if ($valuest['select_head_type_id']) {

                        $IndevisualStudentFeeType = $studentBaseGeneratedFeeFinalArray
                            ->where('student_history_id', $value['id'])
                            ->where('fee_head_type_id', $valuest['id'])
                            ->where('academic_fee_head_id', $values['id']);


                        $studentFeeAmount[] = $IndevisualStudentFeeType->sum('fee_amount');
                        $studentFeeGenerate[] = $IndevisualStudentFeeType->pluck('fee_generate_id');

                        $studentWaiverAmount[] = $IndevisualStudentFeeType->sum('waiver_amount');
                        $studentWaiverGenerate[] = $IndevisualStudentFeeType->pluck('waiver_generate_id');

                    }
                }

            }

        }






        $FeeGeneratecollection = collect($studentFeeGenerate);
        $FeeGeneratecollapsed = $FeeGeneratecollection->collapse();

        $waiverGeneratecollection = collect($studentWaiverGenerate);
        $waiverGeneratecollapsed = $waiverGeneratecollection->collapse();

        $checkUnpaidDemandSlip = SiteStudentFeeDemandSlipDetails::where('student_history_id', $value['id'])->where('status', 1)->first();
     /// dd($checkUnpaidDemandSlip);
        if($checkUnpaidDemandSlip){


        //////
        $present_generate_id_array= $FeeGeneratecollapsed->toArray();
        $previous_generate_id_array= explode(',',$checkUnpaidDemandSlip->site_student_fee_generate_ids);

        $fee_generate_ids = implode(',',array_merge($previous_generate_id_array,$present_generate_id_array));
      //  $site_student_fee_generate_ids[] = $fee_generate_ids;

        $present_waiver_id_array= $waiverGeneratecollapsed->toArray();
        $previous_waiver_id_array= explode(',',$checkUnpaidDemandSlip->site_student_fee_waiver_offer_history_ids);

        $waiver_generate_ids = implode(',',array_merge($present_waiver_id_array,$previous_waiver_id_array));
       // $site_student_fee_waiver_ids[] = $waiver_generate_ids;

      //  $total_fee_amount=$value['fee_amount']+$checkUnpaidDemandSlip->total_amount;
       // $total_waiver_amount=$value['waiver_amount']+$checkUnpaidDemandSlip->waiver_amount;
        /////

        $studentFeebaseArr['site_student_fee_generate_ids'] = $fee_generate_ids;
        $studentFeebaseArr['site_student_fee_waiver_offer_history_ids'] = $waiver_generate_ids;
        $studentFeebaseArr['fee_amount'] = array_sum($studentFeeAmount)+$checkUnpaidDemandSlip->fee_amount;
        //$total_waiver_amount=$value['waiver_amount']+$checkUnpaidDemandSlip->waiver_amount;

    }else{
        $studentFeebaseArr['site_student_fee_generate_ids'] =  implode(',',$FeeGeneratecollapsed->toArray());
        $studentFeebaseArr['site_student_fee_waiver_offer_history_ids'] =  implode(',',$waiverGeneratecollapsed->toArray());
        $studentFeebaseArr['fee_amount'] = array_sum($studentFeeAmount);
      //  $total_waiver_amount=$value['waiver_amount'];

    }

      //  $studentFeebaseArr['site_student_fee_generate_ids'] = implode(',', $FeeGeneratecollapsed->toArray());


        $IndevisualStudentFeeWaiverType = $studentBaseGeneratedFeeWaiverFinalArray
            ->where('student_history_id', $value['id'])
            ->where('fee_head_type_id', null)
            ->where('academic_fee_head_id', null)
            ->first();

        if ($IndevisualStudentFeeWaiverType) {

            $primayAmount = array_sum($studentFeeAmount) - array_sum($studentWaiverAmount);

            $studentFeebaseArr['total_amount'] = $IndevisualStudentFeeWaiverType['percantage_status'] ?
                ($primayAmount - ($primayAmount * $IndevisualStudentFeeWaiverType['amount'] / 100)) :
                ($primayAmount - $IndevisualStudentFeeWaiverType['amount'])+$checkUnpaidDemandSlip->total_amount;

            $studentFeebaseArr['special_waiver_amount'] = $IndevisualStudentFeeWaiverType['percantage_status'] ?
                ($primayAmount * $IndevisualStudentFeeWaiverType['amount'] / 100) :
                $IndevisualStudentFeeWaiverType['amount'];

        } else {
            $studentFeebaseArr['total_amount'] = array_sum($studentFeeAmount) - array_sum($studentWaiverAmount);
            $studentFeebaseArr['special_waiver_amount'] = 0;
        }

        $studentFeebaseArr['waiver_amount'] = array_sum($studentWaiverAmount);
        array_push($studentWaiverGenerate, [$IndevisualStudentFeeWaiverType ? $IndevisualStudentFeeWaiverType['id']: ""]);


        // $FeeWaiverGeneratecollection = collect($studentWaiverGenerate);

        // $WaiverGeneratecollapsed = $FeeWaiverGeneratecollection->collapse();

        // $studentFeebaseArr['site_student_fee_waiver_offer_history_ids'] = implode(',', $WaiverGeneratecollapsed->filter()->toArray());



        $studentFeebaseArray[$key] = array_merge($studentFeebaseArr, $value->toArray());
    }

  //  dd($studentFeebaseArray);

    return collect($studentFeebaseArray);

}

//=====================================update================================================


    public function updateSiteGroupBaseDemandSlip(Request $request)
    {


        DB::beginTransaction();
        try {

            $studentFeebaseArrayCollect = $this->returnStudentFeebaseArrayForUpdate($request);


            if ($request->student_history_id) {
                $SiteStudentIDArray = [$request->student_history_id];
            } else {
                $SiteStudentIDs = $this->returnSelectedSiteStudentIDs($request);
                $SiteStudentIDArray = $SiteStudentIDs->pluck('id');
            }


            $StudentLastDemandSlip = SiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $SiteStudentIDArray)
                ->where('status', true)
                ->get();


            $today = Carbon::today();

            $charges = [];
            $site_student_fee_generate_ids = [];
            $site_student_fee_waiver_ids = [];
            foreach ($studentFeebaseArrayCollect as $key => $value) {

                $site_student_fee_generate_ids[] = $value['site_student_fee_generate_ids'];
                $site_student_fee_waiver_ids[] = $value['site_student_fee_waiver_offer_history_ids'];

                $checkDemandSlip = $StudentLastDemandSlip->where('student_history_id', $value['id'])->first();

                if ($checkDemandSlip) {

                    $checkDemandSlip->site_student_fee_generate_ids = $value['site_student_fee_generate_ids'];
                    $checkDemandSlip->site_student_fee_waiver_offer_history_ids = $value['site_student_fee_waiver_offer_history_ids'];
                    $checkDemandSlip->fee_amount = $value['fee_amount'];
                    $checkDemandSlip->waiver_amount = $value['waiver_amount'];
                    $checkDemandSlip->special_waiver_amount = $value['special_waiver_amount'];
                    $checkDemandSlip->total_amount = $value['total_amount'];
                    $checkDemandSlip->save();

                }


            }

            $site_student_fee_generate_ids_string = implode(',', $site_student_fee_generate_ids);
            $site_student_fee_generate_id = explode(',', $site_student_fee_generate_ids_string);


            $site_student_fee_waiver_ids_string = implode(',', $site_student_fee_waiver_ids);
            $site_student_fee_waiver_id = explode(',', $site_student_fee_waiver_ids_string);

//        return $site_student_fee_generate_id;

            $studentHistoryIDs = $studentFeebaseArrayCollect->pluck('id');
            $RecentelyCreatedDemandSlip = SiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $studentHistoryIDs)
                ->where('status', true)
                ->get(['id', 'student_history_id', 'site_student_fee_generate_ids', 'site_student_fee_waiver_offer_history_ids']);


            //Input site_student_fee_demand_slip_detail_id to GlobalSiteStudentFeeGenerate
            foreach ($studentFeebaseArrayCollect as $key => $value) {

                $checkID = $RecentelyCreatedDemandSlip->where('student_history_id', $value['id'])
                    ->where('site_student_fee_generate_ids', $value['site_student_fee_generate_ids'])->first();


                GlobalSiteStudentFeeGenerate::whereIn('id', explode(',', $value['site_student_fee_generate_ids']))
                    ->update(['site_student_fee_demand_slip_detail_id' => $checkID->id]);

            }

            //Input site_student_fee_demand_slip_detail_id to GlobalSiteStudentFeeWaiverOfferHistory
            foreach ($studentFeebaseArrayCollect as $key => $value) {

                $checkID = $RecentelyCreatedDemandSlip->where('student_history_id', $value['id'])
                    ->where('site_student_fee_generate_ids', $value['site_student_fee_generate_ids'])->first();


                SiteStudentFeeWaiverOfferHistory::whereIn('id', explode(',', $value['site_student_fee_waiver_offer_history_ids']))
                    ->update(['site_student_fee_demand_slip_detail_id' => $checkID->id]);

            }

            if (count($charges) > 0) {
                SiteStudentFeeDemandSlipDetails::insert($charges);
            }


            SiteStudentFeeGenerate::whereIn('id', $site_student_fee_generate_id)
                ->update(['demand_slip_create_status' => true]);

            SiteStudentFeeWaiverOfferHistory::whereIn('id', $site_student_fee_waiver_id)
                ->update(['demand_slip_create_status' => true]);




            DB::commit();
            return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);

        } catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }


    }


    private function returnStudentFeebaseArrayForUpdate(Request $request)
    {

        $SiteStudentIDs = $this->returnSelectedSiteStudentIDs($request);
//        return $SiteStudentIDs;

        if ($request->student_history_id) {
            $SiteStudentIDArray = [$request->student_history_id];
        } else {

            $SiteStudentIDArray = $SiteStudentIDs->pluck('id');
        }


        //=======================Fee Generate and Waiver Generate combination

        $studentBaseGeneratedFeeList = SiteStudentFeeGenerate::with(['siteStudentFeeFineAllocation' => function ($query) {
            $query->select('id', 'academic_fee_head_id');
            $query->with(['academicFeeHead']);
        }])
            ->whereIn('student_history_id', $SiteStudentIDArray)
            ->where('status', true)
            ->get();
        $studentIdForFee = $studentBaseGeneratedFeeList->pluck('student_history_id')->unique();

        $studentBaseGeneratedFeeWaiverList = SiteStudentFeeWaiverOfferHistory::with(['siteStudentFeeFineAllocation' => function ($query) {
            $query->select('id', 'academic_fee_head_id');
            $query->with(['academicFeeHead']);
        }])
            ->whereIn('student_history_id', $SiteStudentIDArray)
            ->where('status', true)
            ->get();

        $studentIdForWaiver = $studentBaseGeneratedFeeWaiverList->pluck('student_history_id')->unique();

        $demandSlipList = SiteStudentFeeDemandSlipDetails::whereIn('student_history_id', $SiteStudentIDArray)
            ->where('status', true)
            ->select('site_student_fee_generate_ids', 'site_student_fee_waiver_offer_history_ids')
            ->get();


        $demand_slip_fee_array = [];
        $demand_slip_waiver_array = [];
        foreach ($demandSlipList as $key => $value) {

            $demand_slip_fee_array[] = $value->site_student_fee_generate_ids;
            $demand_slip_waiver_array[] = $value->site_student_fee_waiver_offer_history_ids;

        }

        $site_fee_ids_string = implode(',', $demand_slip_fee_array);
        $site_fee_ids = explode(',', $site_fee_ids_string);

        $site_waiver_ids_string = implode(',', $demand_slip_waiver_array);
        $site_waiver_ids = explode(',', $site_waiver_ids_string);

        $fee_list_of_demand_slip = SiteStudentFeeGenerate::with(['siteStudentFeeFineAllocation' => function ($query) {
            $query->select('id', 'academic_fee_head_id');
            $query->with(['academicFeeHead']);
        }])
            ->whereIn('id', $site_fee_ids)
            ->get();

        $waiver_list_of_demand_slip = SiteStudentFeeWaiverOfferHistory::with(['siteStudentFeeFineAllocation' => function ($query) {
            $query->select('id', 'academic_fee_head_id');
            $query->with(['academicFeeHead']);
        }])
            ->whereIn('id', $site_waiver_ids)
            ->get();


        $studentBaseGeneratedFee = array_merge($fee_list_of_demand_slip->toArray(), $studentBaseGeneratedFeeList->toArray());
        $studentBaseGeneratedFeeWaiver = array_merge($waiver_list_of_demand_slip->toArray(), $studentBaseGeneratedFeeWaiverList->toArray());

        $studentBaseGeneratedFeeWaiverArray = [];
        $studentBaseGeneratedFeeWaiverArr = Array();
        foreach ($studentBaseGeneratedFeeWaiver as $key => $value) {

            $studentBaseGeneratedFeeWaiverArr['id'] = $value['id'];
            $studentBaseGeneratedFeeWaiverArr['student_history_id'] = $value['student_history_id'];
            $studentBaseGeneratedFeeWaiverArr['amount'] = $value['amount'];
            $studentBaseGeneratedFeeWaiverArr['fee_head_type_id'] = $value['fee_head_type_id'];
            $studentBaseGeneratedFeeWaiverArr['site_student_fee_fine_allocation_id'] = $value['site_student_fee_fine_allocation_id'];
            $studentBaseGeneratedFeeWaiverArr['academic_fee_head_id'] = $value['site_student_fee_fine_allocation'] ? $value['site_student_fee_fine_allocation']['academic_fee_head_id'] : null;
            $studentBaseGeneratedFeeWaiverArr['head_key'] = $value['site_student_fee_fine_allocation'] ? $value['site_student_fee_fine_allocation']['academic_fee_head']['head_key'] : null;
            $studentBaseGeneratedFeeWaiverArr['percantage_status'] = $value['percantage_status'];

            $studentBaseGeneratedFeeWaiverArray[$key] = array_merge($studentBaseGeneratedFeeWaiverArr);
        }

        $studentBaseGeneratedFeeWaiverFinalArray = collect($studentBaseGeneratedFeeWaiverArray);

        $studentBaseGeneratedFeeArr = Array();
        $studentBaseGeneratedFeeArray = [];
        foreach ($studentBaseGeneratedFee as $key => $value) {


            $checkWaiver = $studentBaseGeneratedFeeWaiverFinalArray->where('student_history_id', $value['student_history_id'])
                ->where('site_student_fee_fine_allocation_id', $value['site_student_fee_fine_allocation_id'])
                ->where('fee_head_type_id', $value['fee_head_type_id'])->first();


            if ($checkWaiver) {
                $studentBaseGeneratedFeeArr['fee_generate_id'] = $value['id'];
                $studentBaseGeneratedFeeArr['student_history_id'] = $value['student_history_id'];
                $studentBaseGeneratedFeeArr['fee_amount'] = $value['amount'];
                $studentBaseGeneratedFeeArr['fee_head_type_id'] = $value['fee_head_type_id'];
                $studentBaseGeneratedFeeArr['academic_fee_head_id'] = $value['site_student_fee_fine_allocation']['academic_fee_head_id'];
                $studentBaseGeneratedFeeArr['head_key'] = $value['site_student_fee_fine_allocation']['academic_fee_head']['head_key'];


                $studentBaseGeneratedFeeArr['waiver_generate_id'] = $checkWaiver['id'];
                $studentBaseGeneratedFeeArr['waiver_amount'] = $checkWaiver['percantage_status'] ? (($checkWaiver['amount']) * $value['amount'] / 100) : $checkWaiver['amount'];
                $studentBaseGeneratedFeeArr['waiver_percantage'] = $checkWaiver['percantage_status'] ? $checkWaiver['amount'] : 0;
                $studentBaseGeneratedFeeArr['percantage_status'] = $checkWaiver['percantage_status'];

            } else {
                $studentBaseGeneratedFeeArr['fee_generate_id'] = $value['id'];
                $studentBaseGeneratedFeeArr['student_history_id'] = $value['student_history_id'];
                $studentBaseGeneratedFeeArr['fee_amount'] = $value['amount'];
                $studentBaseGeneratedFeeArr['fee_head_type_id'] = $value['fee_head_type_id'];
                $studentBaseGeneratedFeeArr['academic_fee_head_id'] = $value['site_student_fee_fine_allocation']['academic_fee_head_id'];
                $studentBaseGeneratedFeeArr['head_key'] = $value['site_student_fee_fine_allocation']['academic_fee_head']['head_key'];


                $studentBaseGeneratedFeeArr['waiver_generate_id'] = null;
                $studentBaseGeneratedFeeArr['waiver_amount'] = 0;
                $studentBaseGeneratedFeeArr['waiver_percantage'] = 0;
                $studentBaseGeneratedFeeArr['percantage_status'] = 0;

            }


            $studentBaseGeneratedFeeArray[$key] = array_merge($studentBaseGeneratedFeeArr);

        }


        $studentBaseGeneratedFeeFinalArray = collect($studentBaseGeneratedFeeArray);

        $studentFeebaseArr = Array();
        $studentFeebaseArray = [];
        foreach ($SiteStudentIDs as $key => $value) {


            $studentFeeAmount = [];
            $studentFeeGenerate = [];

            $studentWaiverAmount = [];
            $studentWaiverGenerate = [];

            foreach ($request->FeeHeadTypeList as $keys => $values) {

                if ($values['select_fee_head_id']) {


                    foreach ($values['head_type'] as $keyst => $valuest) {

                        if ($valuest['select_head_type_id']) {

                            $IndevisualStudentFeeType = $studentBaseGeneratedFeeFinalArray
                                ->where('student_history_id', $value['id'])
                                ->where('fee_head_type_id', $valuest['id'])
                                ->where('academic_fee_head_id', $values['id']);

                            $studentFeeAmount[] = $IndevisualStudentFeeType->sum('fee_amount');
                            $studentFeeGenerate[] = $IndevisualStudentFeeType->pluck('fee_generate_id');

                            $studentWaiverAmount[] = $IndevisualStudentFeeType->sum('waiver_amount');
                            $studentWaiverGenerate[] = $IndevisualStudentFeeType->pluck('waiver_generate_id');

                        }
                    }

                }

            }

            $studentFeebaseArr['fee_amount'] = array_sum($studentFeeAmount);
            $FeeGeneratecollection = collect($studentFeeGenerate);
            $FeeGeneratecollapsed = $FeeGeneratecollection->collapse();
            $studentFeebaseArr['site_student_fee_generate_ids'] = implode(',', $FeeGeneratecollapsed->toArray());

            $IndevisualStudentFeeWaiverType = $studentBaseGeneratedFeeWaiverFinalArray
                ->where('student_history_id', $value['id'])
                ->where('fee_head_type_id', null)
                ->where('academic_fee_head_id', null)->first();

            if ($IndevisualStudentFeeWaiverType) {

                $primayAmount = array_sum($studentFeeAmount) - array_sum($studentWaiverAmount);

                $studentFeebaseArr['total_amount'] = $IndevisualStudentFeeWaiverType['percantage_status'] ?
                    ($primayAmount - ($primayAmount * $IndevisualStudentFeeWaiverType['amount'] / 100)) :
                    ($primayAmount - $IndevisualStudentFeeWaiverType['amount']);

                $studentFeebaseArr['special_waiver_amount'] = $IndevisualStudentFeeWaiverType['percantage_status'] ?
                    ($primayAmount * $IndevisualStudentFeeWaiverType['amount'] / 100) :
                    $IndevisualStudentFeeWaiverType['amount'];

            } else {
                $studentFeebaseArr['total_amount'] = array_sum($studentFeeAmount) - array_sum($studentWaiverAmount);
                $studentFeebaseArr['special_waiver_amount'] = 0;
            }

            $studentFeebaseArr['waiver_amount'] = array_sum($studentWaiverAmount);
            array_push($studentWaiverGenerate, [$IndevisualStudentFeeWaiverType['id']]);
            $FeeWaiverGeneratecollection = collect($studentWaiverGenerate);
            $WaiverGeneratecollapsed = $FeeWaiverGeneratecollection->collapse();

            $studentFeebaseArr['site_student_fee_waiver_offer_history_ids'] = implode(',', $WaiverGeneratecollapsed->filter()->toArray());

            $studentFeebaseArray[$key] = array_merge($studentFeebaseArr, $value->toArray());


        }

        return collect($studentFeebaseArray);

    }

    private function returnSelectedSiteStudentIDs(Request $request)
    {

        $data = $request->all();

        if ($request->academic_class_id) {

            if ($request->academic_class_group_present) {

                $siteStudentIDs = StudentHistory::when(!empty($data['student_history_id']), function ($query) use ($data) {
                    $std_id = $data['student_history_id'];
                    return $query->where('id', $std_id['id']);
                })
                    ->where('academic_version_id', $request->academic_version_id)
                    ->where('academic_shift_id', $request->academic_shift_id)
                    ->where('academic_year_id', $request->academic_year_id)
                    ->where('academic_class_id', $request->academic_class_id)
                    ->where('status', true)
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })
                    ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                        return $query->where('academic_session_id', $data['academic_session_id']);
                    })
                    ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                        return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                    })
                    ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                    })
                    ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->get(['id', 'user_id', 'site_id']);


            } else {

                $siteStudentIDs = StudentHistory::when(!empty($data['student_history_id']), function ($query) use ($data) {
                    $std_id = $data['student_history_id'];
                    return $query->where('id', $std_id['id']);
//                        return $query->where('id', $data['student_history_id']);
                })
                    ->where('academic_version_id', $request->academic_version_id)
                    ->where('academic_shift_id', $request->academic_shift_id)
                    ->where('academic_year_id', $request->academic_year_id)
                    ->where('academic_class_id', $request->academic_class_id)
                    ->where('status', true)
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                        return $query->where('academic_student_category_id', $data['academic_student_category_id']);
                    })
                    ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_type_id', $data['academic_student_type_id']);
                    })
                    ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                        return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
                    })
                    ->get(['id', 'user_id', 'site_id']);

            }

        }

        return $siteStudentIDs;

    }

    public function getStudentList(Request $request)
    {
        $data = $request->all();
        $siteStudentList = StudentHistory::with('student')
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('status', true)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->when(!empty($data['academic_student_category_id']), function ($query) use ($data) {
                return $query->where('academic_student_category_id', $data['academic_student_category_id']);
            })
            ->when(!empty($data['academic_student_type_id']), function ($query) use ($data) {
                return $query->where('academic_student_type_id', $data['academic_student_type_id']);
            })
            ->when(!empty($data['academic_student_admission_type_id']), function ($query) use ($data) {
                return $query->where('academic_student_admission_type_id', $data['academic_student_admission_type_id']);
            })
            ->when(!empty($data['student_histories_id']), function ($query) use ($data) {
                return $query->where('id', $data['student_histories_id']);
            })
            ->when(!empty($data['search_user_name']), function ($query) use ($data) {
                return $query->whereHas('student', function ($q) use($data){
                    $q->where('username', $data['search_user_name']);
                });
            })
            ->orderBy('student_roll_number')
            ->orderBy('academic_section_id')
            ->orderBy('academic_class_group_id')
            ->orderBy('academic_class_id')
            ->orderBy('academic_department_id')
            ->get();

        return $siteStudentList;

    }

    public function getDemandSlipList(Request $request)
    {
        $data = $request->all();

         $demand_slip_no = $data['search_demand_slip_no'] - 100000;

        $data_list = array();

    $siteStudentList = $this->getStudentList($request);
        if(count($siteStudentList)){
            $sl = 1;
            foreach ($siteStudentList as $key => $value){
                    $std_demand_slip = $this->siteStudentFeeDemandSlipDetails
                    ->with('createdBy')
                    ->where('student_history_id', $value->id)
                    ->when($data['search_date'], function ($query) use($data){
                        return $query->where('payment_date', $data['search_date']);
                    })
                    ->when($data['search_demand_slip_no'], function ($query) use($demand_slip_no){
                        return $query->where('id', $demand_slip_no);
                    })
                    ->where('status', 1)
                    ->orderBy('id','DESC')
                    ->first();

                if($std_demand_slip){
                 //   $create_by_user = User::where('id', $std_demand_slip->created_by)->first();
                    $data_list[$sl]['sl'] = $sl;
                    $data_list[$sl]['id'] = $std_demand_slip->id;
                    $data_list[$sl]['student_name'] = $value->student->full_name;
                    $data_list[$sl]['user_name'] = $value->student->username;
                    $data_list[$sl]['student_roll_number'] = $value->student_roll_number;
                    $data_list[$sl]['demand_slip_no'] = $std_demand_slip->id + 100000;
                    $data_list[$sl]['generate_date'] = $std_demand_slip->created_date;
                    $data_list[$sl]['generate_by'] = $std_demand_slip->createdBy?$std_demand_slip->createdBy->full_name:"";
                    $data_list[$sl]['payable_amount'] = $std_demand_slip->total_amount??0;
                    $sl++;
                }
            }

        }else{
          //  return Response::json(['message' => 'Sorry data not found!'], 411);
            $data = null;
        }
      //  dd($data_list);

        return $data_list;
    }

    public function singleStudentDemandSlipCancel(Request $request)
    {
//        return $request;
        //=============accounts creation check===============
        $check_accounts_creation = SiteStudentFeeDemandSlipDetails::where('id', $request->id)->where('accounts_received_status',1)->first();
        if($check_accounts_creation){
            throw new Error('Sorry! this payment has been included in accounts!');
        }

        $demand_slip_details = $this->siteStudentFeeDemandSlipDetails->findOrFail($request->id);

        $payment_history = SiteStudentFeePaymentHistory::where('site_student_fee_demand_slip_details_id', $request->id)->where('status', 1)->first();

        if($payment_history){
            throw new Error('Sorry! Payment already taken with this slip!');
//            throw new Error('Sorry! Payment taken with this slip');
        }

        //====================update previous payment due ======================
        if($demand_slip_details->previous_class_due_payment_history_id){
            SiteStudentFeePaymentHistory::where('id', $demand_slip_details->previous_class_due_payment_history_id)->update([
               'previous_academic_class_due_status' => 1,
               'status' => 0,
            ]);
        }

        //====================update fee generate======================
        $fee_generate_ids = explode(',', $demand_slip_details->site_student_fee_generate_ids);
        $fee_generate_details = $this->siteStudentFeeGenerate->whereIn('id', $fee_generate_ids)->update([
            'demand_slip_create_status' => 0,
            'status' => 1,
            'site_student_fee_demand_slip_detail_id' => null,

        ]);


        //====================update waiver======================
        $waiver_ids = explode(',', $demand_slip_details->site_student_fee_waiver_offer_history_ids);
        $waiver_details = $this->siteStudentFeeWaiverOfferHistory->whereIn('id', $waiver_ids)->update([
            'demand_slip_create_status' => 0,
        ]);


        //============================delete fee fine=========================
        $fee_fine_details_due_fine = SiteStudentFeeFine::where('student_history_id',$demand_slip_details->student_history_id)
            ->where('fee_type', 'duefine')
            ->where('status', 1)
            ->delete();


        //====================active previous demand slip======================
        $previous_demand_slip = $this->siteStudentFeeDemandSlipDetails->where('id', $demand_slip_details->previous_site_student_fee_demand_slip_detail_id)->first();

        if ($previous_demand_slip){
            if($previous_demand_slip->due_transfer_to_promoted_student_history_id){
                $previous_demand_slip->update([
                    'status' => 0,
                    'previous_academic_class_due_status' => 1
                ]);

                //============================delete previous class fee fine=========================
                $fee_fine_details_due_fine = SiteStudentFeeFine::where('student_history_id', $previous_demand_slip->student_history_id)
                    ->where('fee_type', 'duefine')
                    ->where('status', 1)
                    ->delete();

            }else{
                $previous_demand_slip->update(['status' => 1]);

            }
            //============active previous payment===================
            $previous_payment_detials = SiteStudentFeePaymentHistory::where('site_student_fee_demand_slip_details_id', $previous_demand_slip->id)
                                                                        ->orderBy('id', 'desc')->first();
            if($previous_payment_detials){
               $previous_payment_detials->update([
                  'status' => 1,
               ]);

//               if($previous_payment_detials->due_amount == 0){
//                    $previous_demand_slip->update(['status' => 0]);
//                }
            }

            $prev_site_student_fee_generate_ids = explode(',', $previous_demand_slip->site_student_fee_generate_ids);

            $prevStudentFeeList=SiteStudentFeeGenerate::whereIn('id',$prev_site_student_fee_generate_ids)
                 ->where('status',true)
                 ->get();

            foreach($prevStudentFeeList as $prev_student_fee){
                $prev_student_fee->update([
                    'site_student_fee_demand_slip_detail_id'=>$previous_demand_slip->id,
                ]);
            }

        }

           //====================delete demand slip======================
           $site_student_fee_generate_ids = explode(',', $demand_slip_details->site_student_fee_generate_ids);
           SiteStudentHeadWiseFeePaymentHistory::whereIn('student_fee_generate_id',$site_student_fee_generate_ids)->delete();

           $studentFeeList=SiteStudentFeeGenerate::whereIn('id',$site_student_fee_generate_ids)
                ->where('status',true)
                ->where('site_student_fee_demand_slip_detail_id',$demand_slip_details->id)
                ->get();

         //   dd($studentFeeList);

       foreach($studentFeeList as $student_fee){

           $student_fee->update([
              'demand_slip_create_status'=>0,
              'site_student_fee_demand_slip_detail_id'=>null,
           ]);
       }

        //====================delete demand slip======================
        if($demand_slip_details->delete()){
            $site_student_fee_waiver_offer_history_ids = explode(',', $demand_slip_details->site_student_fee_waiver_offer_history_ids);
            $waiver_history = SiteStudentFeeWaiverOfferHistory::whereIn('id', $site_student_fee_waiver_offer_history_ids)->update([
               'demand_slip_create_status'=>0,
               'site_student_fee_demand_slip_detail_id'=>null,
            ]);
        }




        return Response::json(['message' => 'Demand Slip Successfully Cancelled!', 'mode' => 'Cancelled!'], 200);
    }


}
